import { PrismaClient } from "@prisma/client";
import bcrypt from "bcryptjs";

const prisma = new PrismaClient();

async function main() {
  const adminEmail = process.env.INIT_ADMIN_EMAIL || "admin@example.com";
  const adminPass = process.env.INIT_ADMIN_PASSWORD || "admin123";
  const operatorEmail = process.env.INIT_OPERATOR_EMAIL || "op@example.com";
  const operatorPass = process.env.INIT_OPERATOR_PASSWORD || "operator123";

  const [adminHash, opHash] = await Promise.all([
    bcrypt.hash(adminPass, 10),
    bcrypt.hash(operatorPass, 10)
  ]);

  await prisma.user.upsert({
    where: { email: adminEmail },
    update: {},
    create: { email: adminEmail, name: "Admin", role: "ADMIN", passwordHash: adminHash }
  });

  await prisma.user.upsert({
    where: { email: operatorEmail },
    update: {},
    create: { email: operatorEmail, name: "Operator", role: "OPERATOR", passwordHash: opHash }
  });

  console.log("Seeded:", { adminEmail, operatorEmail });
}

main().finally(()=>prisma.$disconnect());
