import { customAlphabet } from "nanoid";
import bcrypt from "bcryptjs";

const alphabet = "abcdefghijklmnopqrstuvwxyz0123456789";
export const genSlug = customAlphabet(alphabet, 6);

export function withUTM(url: string, params: {source?: string; medium?: string; campaign?: string}) {
  const u = new URL(url);
  if (params.source) u.searchParams.set("utm_source", params.source);
  if (params.medium) u.searchParams.set("utm_medium", params.medium);
  if (params.campaign) u.searchParams.set("utm_campaign", params.campaign);
  return u.toString();
}

export async function hashPassword(pass?: string) {
  if (!pass) return null;
  const salt = await bcrypt.genSalt(10);
  return bcrypt.hash(pass, salt);
}

export async function verifyPassword(plain: string, hash: string) {
  return bcrypt.compare(plain, hash);
}
