type Props = { src: string };

export default function ToolFrame({ src }: Props) {
  return (
    <div className="w-full h-screen">
      <iframe
        key={src}
        src={src}
        className="w-full h-full border-0"
        referrerPolicy="no-referrer"
        sandbox="allow-scripts allow-forms allow-same-origin allow-popups"
        allow="clipboard-read; clipboard-write; fullscreen"
      />
    </div>
  );
}
