"use client";

import { signOut } from "next-auth/react";

export default function SignoutBar({ email, role }: { email?: string | null; role?: string | null }) {
  return (
    <div className="flex items-center gap-3">
      <span className="text-xs" style={{ color: "var(--muted)" }}>
        {email} · <b>{role}</b>
      </span>
      <button
        className="btn-ghost"
        onClick={() => signOut({ callbackUrl: "/signin" })}
      >
        Sign out
      </button>
    </div>
  );
}

