﻿"use client";

import React from "react";

type Props = {
  open: boolean;
  onClose: () => void;
  title: string;
  children: React.ReactNode;
  footer?: React.ReactNode;
};

export default function Modal({ open, onClose, title, children, footer }: Props) {
  if (!open) return null;
  return (
    <div className="fixed inset-0 z-50 flex items-center justify-center bg-black/40 p-4">
      <div className="w-full max-w-lg rounded-2xl shadow-lg bg-[var(--panel)] text-[#EDEAFF] border" style={{ borderColor: 'var(--line)' }}>
        <div className="flex items-center justify-between border-b px-4 py-3" style={{ borderColor: 'var(--line)' }}>
          <div className="font-semibold">{title}</div>
          <button onClick={onClose} className="rounded-lg px-2 py-1 text-sm hover:bg-[#1c1536]" aria-label="Close">&times;</button>
        </div>
        <div className="p-4">{children}</div>
        <div className="border-t px-4 py-3 flex items-center justify-end gap-2" style={{ borderColor: 'var(--line)' }}>
          {footer ?? (
            <button onClick={onClose} className="btn-ghost">Close</button>
          )}
        </div>
      </div>
    </div>
  );
}
