﻿"use client";

import { useState } from "react";
import { signIn } from "next-auth/react";
import { useSearchParams } from "next/navigation";

export default function SignInClient() {
  const params = useSearchParams();
  const callbackUrl = params.get("callbackUrl") || "/dashboard";
  const [email, setEmail] = useState("");
  const [password, setPassword] = useState("");
  const [err, setErr] = useState<string | null>(null);
  const [loading, setLoading] = useState(false);

  async function onSubmit(e: React.FormEvent) {
    e.preventDefault();
    setLoading(true);
    setErr(null);
    const res = await signIn("credentials", { email, password, redirect: false, callbackUrl });
    if (res?.ok) window.location.href = callbackUrl;
    else {
      setErr("Email / password salah");
      setLoading(false);
    }
  }

  return (
    <div
      className="min-h-screen grid place-items-center"
      style={{
        background:
          "radial-gradient(1200px 600px at 20% -10%, rgba(139,92,246,.25), transparent), radial-gradient(900px 500px at 80% 10%, rgba(99,102,241,.2), transparent), var(--bg)",
      }}
    >
      <div className="w-full max-w-md p-6">
        <div className="card p-6 space-y-4 text-center">
          <div className="flex justify-center">
            <img
              src="https://res.cloudinary.com/dfpdnfza4/image/upload/v1761342843/seosports_phnwwy.png"
              alt="Bre Logo"
              className="h-13 w-auto logo-glow"
            />
          </div>
          <form onSubmit={onSubmit} className="space-y-3 text-left">
            <div className="space-y-1">
              <label className="label">Email</label>
              <input value={email} onChange={(e) => setEmail(e.target.value)} placeholder="you@mail.com" className="input" />
            </div>
            <div className="space-y-1">
              <label className="label">Password</label>
              <input value={password} onChange={(e) => setPassword(e.target.value)} type="password" placeholder="Password" className="input" />
            </div>
            {err && <div className="text-sm text-rose-400">{err}</div>}
            <button disabled={loading} className="btn-gradient w-full">{loading ? "Loading..." : "Sign in"}</button>
          </form>

          <div className="help">Gunakan akun admin/operator yang sudah di-seed.</div>
        </div>
        <div className="text-center mt-4 text-xs" style={{ color: "var(--muted)" }}>
          Powered by: <b>IDNSEO</b>
        </div>
      </div>
    </div>
  );
}
