﻿import Providers from "@/components/Providers";

import "./globals.css";
import type { Metadata } from "next";
import Sidebar from "@/components/Sidebar";
import SignoutBar from "@/components/SignoutBar";
import { authSession } from "@/lib/auth";

export const metadata: Metadata = {
  title: "Panel Pribadi",
  description: "Dashboard internal untuk kelola tools & shortlink.",
  icons: {
    icon: "https://res.cloudinary.com/dfpdnfza4/image/upload/v1761343246/icon_nwe4s6.png",
  },
};

export default async function RootLayout({ children }: { children: React.ReactNode }) {
  const session = await authSession();

  return (
    <html lang="en">
      <head>
        <link
          href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0"
          rel="stylesheet"
        />
      </head>
      <body>
        <Providers>
          <div className="flex">
            {session?.user && <Sidebar />}
            <main className="flex-1 min-h-screen">
              {session?.user && (
                <div className="fixed top-3 right-3 z-20">
                  <div
                    className="inline-flex items-center rounded-full border px-3 py-2"
                    style={{ background: "rgba(23, 18, 43, .6)", borderColor: "var(--line)" }}
                  >
                    <SignoutBar email={session.user.email} role={(session.user as any).role} />
                  </div>
                </div>
              )}
              {children}
            </main>
          </div>
        </Providers>
      </body>
    </html>
  );
}





